<p data-nodeid="176572" class="">本课时我们将讲解一下对于“<strong data-nodeid="176678">大对象</strong>”的优化。这里的“大对象”，是一个泛化概念，它可能存放在 JVM 中，也可能正在网络上传输，也可能存在于数据库中。</p>
<p data-nodeid="176573">那么为什么大对象会影响我们的应用性能呢？</p>
<ul data-nodeid="176574">
<li data-nodeid="176575">
<p data-nodeid="176576">第一，大对象<strong data-nodeid="176685">占用的资源多</strong>，垃圾回收器要花一部分精力去对它进行回收；</p>
</li>
<li data-nodeid="176577">
<p data-nodeid="176578">第二，大对象在不同的<strong data-nodeid="176695">设备</strong>之间<strong data-nodeid="176696">交换</strong>，会耗费网络流量，以及昂贵的 I/O；</p>
</li>
<li data-nodeid="176579">
<p data-nodeid="176580">第三，对大对象的解析和处理操作是<strong data-nodeid="176702">耗时</strong>的，对象职责不聚焦，就会承担额外的性能开销。</p>
</li>
</ul>
<p data-nodeid="176581">结合我们前面提到的缓存，以及对象的池化操作，加上对一些中间结果的保存，我们能够对大对象进行初步的提速。</p>
<p data-nodeid="176582">但这还远远不够，我们仅仅减少了对象的创建频率，但并没有改变对象“大”这个事实。本课时，将从 JDK 的一些知识点讲起，先来看几个面试频率比较高的<strong data-nodeid="176717">对象复用问题</strong>；接下来，从数据的<strong data-nodeid="176718">结构纬度</strong>和<strong data-nodeid="176719">时间维度</strong>出发，分别逐步看一下一些把对象变小，把操作聚焦的策略。</p>
<h3 data-nodeid="176583">String 的 substring 方法</h3>
<p data-nodeid="176584">我们都知道，String 在 Java 中是不可变的，如果你改动了其中的内容，它就会生成一个新的字符串。</p>
<p data-nodeid="176585">如果我们想要用到字符串中的一部分数据，就可以使用 substring 方法。</p>
<p data-nodeid="176586"><img src="https://s0.lgstatic.com/i/image/M00/40/CB/CgqCHl8zkSuAJiz1AAXioe0G9Vc058.png" alt="Drawing 0.png" data-nodeid="176725"></p>
<p data-nodeid="176587">如上图所示，当我们需要一个子字符串的时候，substring 生成了一个新的字符串，这个字符串通过构造函数的 Arrays.copyOfRange 函数进行构造。</p>
<p data-nodeid="176588">这个函数在 JDK7 之后是没有问题的，但在 JDK6 中，却有着内存泄漏的风险，我们可以学习一下这个案例，来看一下大对象复用可能会产生的问题。</p>
<p data-nodeid="176589"><img src="https://s0.lgstatic.com/i/image/M00/40/CB/CgqCHl8zkTWAcVQ4AAEesZzLTVo509.png" alt="Drawing 1.png" data-nodeid="176730"></p>
<p data-nodeid="176590">上图是我从 JDK 官方的一张截图。可以看到，它在创建子字符串的时候，并不只拷贝所需要的对象，而是把整个 value 引用了起来。如果原字符串比较大，即使不再使用，内存也不会释放。</p>
<p data-nodeid="176591">比如，一篇文章内容可能有几兆，我们仅仅是需要其中的摘要信息，也不得不维持整个的大对象。</p>
<pre class="lang-java" data-nodeid="176592"><code data-language="java">String content = dao.getArticle(id); 
String summary=content.substring(<span class="hljs-number">0</span>,<span class="hljs-number">100</span>); 
articles.put(id,summary);
</code></pre>
<p data-nodeid="176593"><strong data-nodeid="176736">有一些工作年限比较长的面试官，对 substring 还停留在 JDK6 的印象，但其实，Java 已经将这个 bug 给修改了。</strong></p>
<p data-nodeid="176594"><strong data-nodeid="176741">这对我们的借鉴意义是</strong>：如果你创建了比较大的对象，并基于这个对象生成了一些其他的信息，这个时候，一定要记得去掉和这个大对象的引用关系。</p>
<h3 data-nodeid="176595">集合大对象扩容</h3>
<p data-nodeid="176596">对象扩容，在 Java 中是司空见惯的现象，比如 StringBuilder、StringBuffer、HashMap，ArrayList 等。概括来讲，Java 的集合，包括 List、Set、Queue、Map 等，其中的数据都不可控。在容量不足的时候，都会有扩容操作，扩容操作需要重新组织数据，所以都不是线程安全的。</p>
<p data-nodeid="176597">我们先来看下 StringBuilder 的扩容代码：</p>
<pre class="lang-java" data-nodeid="176598"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">void</span> <span class="hljs-title">expandCapacity</span><span class="hljs-params">(<span class="hljs-keyword">int</span> minimumCapacity)</span> </span>{ 
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">int</span> newCapacity = value.length * <span class="hljs-number">2</span> + <span class="hljs-number">2</span>; 
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">if</span> (newCapacity - minimumCapacity &lt; <span class="hljs-number">0</span>) 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;newCapacity = minimumCapacity; 
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">if</span> (newCapacity &lt; <span class="hljs-number">0</span>) { 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">if</span> (minimumCapacity &lt; <span class="hljs-number">0</span>) <span class="hljs-comment">// overflow </span>
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> OutOfMemoryError(); 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;newCapacity = Integer.MAX_VALUE; 
 &nbsp; &nbsp; &nbsp;  } 
 &nbsp; &nbsp; &nbsp; &nbsp;value = Arrays.copyOf(value, newCapacity); 
}
</code></pre>
<p data-nodeid="176599">容量不够的时候，会将内存翻倍，并使用 Arrays.copyOf 复制源数据。</p>
<p data-nodeid="176600">下面是 HashMap 的扩容代码，扩容后大小也是翻倍。它的扩容动作就复杂得多，除了有负载因子的影响，它还需要把原来的数据重新进行散列，由于无法使用 native 的 Arrays.copy 方法，速度就会很慢。</p>
<pre class="lang-java" data-nodeid="176601"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">void</span> <span class="hljs-title">addEntry</span><span class="hljs-params">(<span class="hljs-keyword">int</span> hash, K key, V value, <span class="hljs-keyword">int</span> bucketIndex)</span> </span>{ 
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">if</span> ((size &gt;= threshold) &amp;&amp; (<span class="hljs-keyword">null</span> != table[bucketIndex])) { 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;resize(<span class="hljs-number">2</span> * table.length); 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;hash = (<span class="hljs-keyword">null</span> != key) ? hash(key) : <span class="hljs-number">0</span>; 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;bucketIndex = indexFor(hash, table.length); 
 &nbsp; &nbsp; &nbsp;  } 
 &nbsp; &nbsp; &nbsp; &nbsp;createEntry(hash, key, value, bucketIndex); 
} 
 
<span class="hljs-function"><span class="hljs-keyword">void</span> <span class="hljs-title">resize</span><span class="hljs-params">(<span class="hljs-keyword">int</span> newCapacity)</span> </span>{ 
 &nbsp; &nbsp; &nbsp; &nbsp;Entry[] oldTable = table; 
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">int</span> oldCapacity = oldTable.length; 
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">if</span> (oldCapacity == MAXIMUM_CAPACITY) { 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;threshold = Integer.MAX_VALUE; 
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">return</span>; 
 &nbsp; &nbsp; &nbsp;  } 
 &nbsp; &nbsp; &nbsp; &nbsp;Entry[] newTable = <span class="hljs-keyword">new</span> Entry[newCapacity]; 
 &nbsp; &nbsp; &nbsp; &nbsp;transfer(newTable, initHashSeedAsNeeded(newCapacity)); 
 &nbsp; &nbsp; &nbsp; &nbsp;table = newTable; 
 &nbsp; &nbsp; &nbsp; &nbsp;threshold = (<span class="hljs-keyword">int</span>)Math.min(newCapacity * loadFactor, MAXIMUM_CAPACITY + <span class="hljs-number">1</span>); 
}
</code></pre>
<p data-nodeid="176602">List 的代码大家可自行查看，也是阻塞性的，扩容策略是原长度的 1.5 倍。</p>
<p data-nodeid="176603">由于集合在代码中使用的频率非常高，如果你知道具体的数据项上限，那么不妨设置一个合理的初始化大小。比如，HashMap 需要 1024 个元素，需要 7 次扩容，会影响应用的性能。<strong data-nodeid="176752">面试中会频繁出现这个问题，你需要了解这些扩容操作对性能的影响。</strong></p>
<p data-nodeid="176604">但是要注意，像 HashMap 这种有负载因子的集合（0.75），<strong data-nodeid="176758">初始化大小 = 需要的个数/负载因子+1</strong>，如果你不是很清楚底层的结构，那就不妨保持默认。</p>
<p data-nodeid="176605">接下来，我将从数据的<strong data-nodeid="176768">结构纬度</strong>和<strong data-nodeid="176769">时间维度</strong>出发，讲解一下应用层面的优化。</p>
<h3 data-nodeid="176606">保持合适的对象粒度</h3>
<p data-nodeid="176607">给你分享一个实际案例：我们有一个并发量非常高的业务系统，需要频繁使用到用户的基本数据。</p>
<p data-nodeid="176608">如下图所示，由于用户的基本信息，都是存放在另外一个服务中，所以每次用到用户的基本信息，都需要有一次网络交互。更加让人无法接受的是，即使是只需要用户的性别属性，也需要把所有的用户信息查询，拉取一遍。</p>
<p data-nodeid="176609"><img src="https://s0.lgstatic.com/i/image/M00/40/CB/CgqCHl8zkWGABcIuAADyGLJaQ44758.png" alt="Drawing 2.png" data-nodeid="176775"></p>
<p data-nodeid="176610">为了加快数据的查询速度，根据我们之前 <a href="https://kaiwu.lagou.com/course/courseInfo.htm?sid=&amp;courseId=356&amp;lagoufrom=noapp" data-nodeid="176781">《08 | 案例分析：Redis 如何助力秒杀业务》</a>的描述，对数据进行了初步的缓存，放入到了 Redis 中，查询性能有了大的改善，但每次还是要查询很多冗余数据。</p>
<p data-nodeid="176611">原始的 redis key 是这样设计的：</p>
<pre class="lang-java" data-nodeid="176612"><code data-language="java">type: string 
key: user_${userid} 
value: json
</code></pre>
<p data-nodeid="176613">这样的设计有两个问题：</p>
<ul data-nodeid="176614">
<li data-nodeid="176615">
<p data-nodeid="176616">查询其中某个字段的值，需要把所有 json 数据查询出来，并自行解析；</p>
</li>
<li data-nodeid="176617">
<p data-nodeid="176618">更新其中某个字段的值，需要更新整个 json 串，代价较高。</p>
</li>
</ul>
<p data-nodeid="176619">针对这种大粒度 json 信息，就可以采用打散的方式进行优化，使得每次更新和查询，都有聚焦的目标。</p>
<p data-nodeid="176620">接下来对 Redis 中的数据进行了以下设计，采用 hash 结构而不是 json 结构：</p>
<pre class="lang-java" data-nodeid="176621"><code data-language="java">type: hash 
key: user_${userid} 
value: {sex:f, id:<span class="hljs-number">1223</span>, age:<span class="hljs-number">23</span>}
</code></pre>
<p data-nodeid="176622">这样，我们使用 hget 命令，或者 hmget 命令，就可以获取到想要的数据，加快信息流转的速度。</p>
<h3 data-nodeid="176623">Bitmap 把对象变小</h3>
<p data-nodeid="176624">除了以上操作，还能再进一步优化吗？比如，我们系统中就频繁用到了用户的性别数据，用来发放一些礼品，推荐一些异性的好友，定时循环用户做一些清理动作等；或者，存放一些用户的状态信息，比如是否在线，是否签到，最近是否发送信息等，从而统计一下活跃用户等。那么对<strong data-nodeid="176796">是、否</strong>这两个值的操作，就可以使用 Bitmap 这个结构进行压缩。</p>
<p data-nodeid="176625"><strong data-nodeid="176800">这里还有个高频面试问题，那就是 Java 的 Boolean 占用的是多少位？</strong></p>
<p data-nodeid="176626">在 Java 虚拟机规范里，描述是：将 Boolean 类型映射成的是 1 和 0 两个数字，它占用的空间是和 int 相同的 32 位。即使有的虚拟机实现把 Boolean 映射到了 byte 类型上，它所占用的空间，对于大量的、有规律的 Boolean 值来说，也是太大了。</p>
<p data-nodeid="176627">如代码所示，通过判断 int 中的每一位，它可以保存 32 个 Boolean 值！</p>
<pre class="lang-java" data-nodeid="176628"><code data-language="java"><span class="hljs-keyword">int</span> a= <span class="hljs-number">0b0001_0001_1111_1101_1001_0001_1111_1101</span>;
</code></pre>
<p data-nodeid="176943" class="">Bitmap 就是使用 Bit 进行记录的数据结构，里面存放的数据不是 0 就是 1。还记得我们在之前 <a href="https://kaiwu.lagou.com/course/courseInfo.htm?sid=&amp;courseId=356&amp;lagoufrom=noapp" data-nodeid="176949">《08 | 案例分析：Redis 如何助力秒杀业务》</a>中提到的缓存穿透吗？就可以使用 Bitmap 避免，Java 中的相关结构类，就是 java.util.BitSet，BitSet 底层是使用 long 数组实现的，所以它的最小容量是 64。</p>

<p data-nodeid="178437" class="te-preview-highlight">10 亿的 Boolean 值，只需要 128MB 的内存，下面既是一个占用了 256MB 的用户性别的判断逻辑，可以涵盖长度为 10 亿的 ID。</p>


<pre class="lang-java" data-nodeid="176631"><code data-language="java"><span class="hljs-keyword">static</span> BitSet missSet = <span class="hljs-keyword">new</span> BitSet(<span class="hljs-number">010_000_000_000</span>); 
<span class="hljs-keyword">static</span> BitSet sexSet = <span class="hljs-keyword">new</span> BitSet(<span class="hljs-number">010_000_000_000</span>); 
<span class="hljs-function">String <span class="hljs-title">getSex</span><span class="hljs-params">(<span class="hljs-keyword">int</span> userId)</span> </span>{ 
 &nbsp; &nbsp;<span class="hljs-keyword">boolean</span> notMiss = missSet.get(userId); 
 &nbsp; &nbsp;<span class="hljs-keyword">if</span> (!notMiss) { 
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-comment">//lazy fetch </span>
 &nbsp; &nbsp; &nbsp; &nbsp;String lazySex = dao.getSex(userId); 
 &nbsp; &nbsp; &nbsp; &nbsp;missSet.set(userId, <span class="hljs-keyword">true</span>); 
 &nbsp; &nbsp; &nbsp; &nbsp;sexSet.set(userId, <span class="hljs-string">"female"</span>.equals(lazySex)); 
 &nbsp;  } 
 &nbsp; &nbsp;<span class="hljs-keyword">return</span> sexSet.get(userId) ? <span class="hljs-string">"female"</span> : <span class="hljs-string">"male"</span>; 
}
</code></pre>
<p data-nodeid="176632">这些数据，放在堆内内存中，还是过大了。幸运的是，Redis 也支持 Bitmap 结构，如果内存有压力，我们可以把这个结构放到 Redis 中，判断逻辑也是类似的。</p>
<p data-nodeid="176633"><strong data-nodeid="176815">再插一道面试算法题：给出一个 1GB 内存的机器，提供 60亿 int 数据，如何快速判断有哪些数据是重复的？</strong></p>
<p data-nodeid="176634">大家可以类比思考一下。Bitmap 是一个比较底层的结构，在它之上还有一个叫作布隆过滤器的结构（Bloom Filter），布隆过滤器可以判断一个值不存在，或者可能存在。</p>
<p data-nodeid="176635"><img src="https://s0.lgstatic.com/i/image/M00/40/C0/Ciqc1F8zkZWAKUhuAACFphHz8XU285.png" alt="Drawing 3.png" data-nodeid="176819"></p>
<p data-nodeid="176636">如图，它相比较 Bitmap，它多了一层 hash 算法。既然是 hash 算法，就会有冲突，所以有可能有多个值落在同一个 bit 上。它不像 HashMap一样，使用链表或者红黑树来处理冲突，而是直接将这个hash槽重复使用。从这个特性我们能够看出，布隆过滤器能够明确表示一个值不在集合中，但无法判断一个值确切的在集合中。</p>
<p data-nodeid="176637">Guava 中有一个 BloomFilter 的类，可以方便地实现相关功能。</p>
<p data-nodeid="176638">上面这种优化方式，<strong data-nodeid="176827">本质上也是把大对象变成小对象的方式</strong>，在软件设计中有很多类似的思路。比如像一篇新发布的文章，频繁用到的是摘要数据，就不需要把整个文章内容都查询出来；用户的 feed 信息，也只需要保证可见信息的速度，而把完整信息存放在速度较慢的大型存储里。</p>
<h3 data-nodeid="176639">数据的冷热分离</h3>
<p data-nodeid="176640">数据除了横向的结构纬度，还有一个纵向的<strong data-nodeid="176838">时间维度</strong>，对时间维度的优化，最有效的方式就是<strong data-nodeid="176839">冷热分离</strong>。</p>
<p data-nodeid="176641">所谓<strong data-nodeid="176849">热数据</strong>，就是靠近用户的，被频繁使用的数据；而<strong data-nodeid="176850">冷数据</strong>是那些访问频率非常低，年代非常久远的数据。</p>
<p data-nodeid="176642">同一句复杂的 SQL，运行在几千万的数据表上，和运行在几百万的数据表上，前者的效果肯定是很差的。所以，虽然你的系统刚开始上线时速度很快，但随着时间的推移，数据量的增加，就会渐渐变得很慢。</p>
<p data-nodeid="176643"><strong data-nodeid="176856">冷热分离</strong>是把数据分成两份，如下图，一般都会保持一份全量数据，用来做一些耗时的统计操作。</p>
<p data-nodeid="176644"><img src="https://s0.lgstatic.com/i/image/M00/40/CB/CgqCHl8zkaGALD0uAADj7bx0YMY053.png" alt="Drawing 4.png" data-nodeid="176859"></p>
<p data-nodeid="176645"><strong data-nodeid="176863">由于冷热分离在工作中经常遇到，所以面试官会频繁问到数据冷热分离的方案。下面简单介绍三种：</strong></p>
<h4 data-nodeid="176646">1.数据双写</h4>
<p data-nodeid="176647">把对冷热库的插入、更新、删除操作，全部放在一个统一的事务里面。由于热库（比如 MySQL）和冷库（比如 Hbase）的类型不同，这个事务大概率会是分布式事务。在项目初期，这种方式是可行的，但如果是改造一些遗留系统，分布式事务基本上是改不动的，我通常会把这种方案直接废弃掉。</p>
<h4 data-nodeid="176648">2.写入 MQ 分发</h4>
<p data-nodeid="176649">通过 MQ 的发布订阅功能，在进行数据操作的时候，先不落库，而是发送到 MQ 中。单独启动消费进程，将 MQ 中的数据分别落到冷库、热库中。使用这种方式改造的业务，逻辑非常清晰，结构也比较优雅。像订单这种结构比较清晰、对顺序性要求较低的系统，就可以采用 MQ 分发的方式。但如果你的数据库实体量非常大，用这种方式就要考虑程序的复杂性了。</p>
<h4 data-nodeid="176650">3.使用 Binlog 同步</h4>
<p data-nodeid="176651">针对 MySQL，就可以采用 Binlog 的方式进行同步，使用 Canal 组件，可持续获取最新的 Binlog 数据，结合 MQ，可以将数据同步到其他的数据源中。</p>
<h3 data-nodeid="176652">思维发散</h3>
<p data-nodeid="176653">对于结果集的操作，我们可以再发散一下思维。可以将一个简单冗余的结果集，改造成复杂高效的数据结构。这个复杂的数据结构可以代理我们的请求，有效地转移耗时操作。</p>
<ul data-nodeid="176654">
<li data-nodeid="176655">
<p data-nodeid="176656">比如，我们常用的<strong data-nodeid="176877">数据库索引</strong>，就是一种对数据的重新组织、加速。</p>
</li>
</ul>
<p data-nodeid="176657">B+ tree 可以有效地减少数据库与磁盘交互的次数，它通过类似 B+ tree 的数据结构，将最常用的数据进行索引，存储在有限的存储空间中。</p>
<ul data-nodeid="176658">
<li data-nodeid="176659">
<p data-nodeid="176660">还有就是，<strong data-nodeid="176884">在 RPC 中常用的序列化</strong>。</p>
</li>
</ul>
<p data-nodeid="176661">有的服务是采用的 SOAP 协议的 WebService，它是基于 XML 的一种协议，内容大传输慢，效率低下。现在的 Web 服务中，大多数是使用 json 数据进行交互的，json 的效率相比 SOAP 就更高一些。</p>
<p data-nodeid="176662">另外，大家应该都听过 google 的 protobuf，由于它是二进制协议，而且对数据进行了压缩，性能是非常优越的。protobuf 对数据压缩后，大小只有 json 的 1/10，xml 的 1/20，但是性能却提高了 5-100 倍。</p>
<p data-nodeid="176663">protobuf 的设计是值得借鉴的，它通过 tag|leng|value 三段对数据进行了非常紧凑的处理，解析和传输速度都特别快。</p>
<h3 data-nodeid="176664">小结</h3>
<p data-nodeid="176665">最后总结一下本课时的内容重点：</p>
<p data-nodeid="176666">首先，我们看了比较老的 JDK 版本中，String 为了复用引起的内容泄漏问题，所以我们平常的编码中，一定要注意<strong data-nodeid="176899">大对象</strong>的回收，及时切断与它的联系。</p>
<p data-nodeid="176667">接下来，我们看了 Java 中集合的一些<strong data-nodeid="176905">扩容</strong>操作，如果你知道确切的集合大小，就可以指定一个初始值，避免耗时的扩容操作。</p>
<p data-nodeid="176668">针对大对象，我们有结构纬度的优化和时间维度的优化两种方法：</p>
<p data-nodeid="176669">从<strong data-nodeid="176924">结构纬度</strong>来说，通过把对象<strong data-nodeid="176925">切分成合适的粒度</strong>，可以把操作集中在小数据结构上，减少时间处理成本；通过把对象进行<strong data-nodeid="176926">压缩、转换</strong>，或者<strong data-nodeid="176927">提取热点数据</strong>，就可以避免大对象的存储和传输成本。</p>
<p data-nodeid="176670">从<strong data-nodeid="176937">时间纬度</strong>来说，就可以通过<strong data-nodeid="176938">冷热分离</strong>的手段，将常用的数据存放在高速设备中，减少数据处理的集合，加快处理速度。</p>
<p data-nodeid="176671">到现在为止，我们学习了缓冲、缓存、对象池化、结果缓存池、大对象处理等优化性能的手段，由于它们都加入了额外的中间层，会使得编程模型变得复杂。</p>
<p data-nodeid="176672" class="">接下来，我将在下一课时《11 | 案例分析：如何用设计模式优化性能》中介绍几种常用的设计模式，来看一下设计模式可以如何助力我们的性能优化，又有哪些可以注意的地方。</p>

---

### 精选评论

##### **用户8700：
> 128M存的是10亿数据吧？128*1024*1024*8=1,073,741,824

##### **2081：
> 老师总结的很到位，还是涉及到了挺多基础知识点的

##### **烽：
> 老师，为什么说 在 冷热数据分离 方案中，实施 数据双写 时， 针对 已有系统的改造，分布式事务改不动？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 遗留系统一般技术栈比较老，而且代码比较分散，事务操作不集中。需要先进行一次集中性的重构，但这个重构陈本很大

##### **华：
> 你好 老师 问个关于redis bimap的问题 如果作为签到使用,用户uid比较稀疏导致key比较大 该怎么处理呢?

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 如果你只是存是和否的话，如果特别稀疏，可以作为用户的一项属性存在；一般签到都是统计用户的签到历史的，比如最近一个月的签到情况，这种情况下bitmap的key就是日期。而不是一个日期一个bitmap

##### **运：
> 这一篇文章很赞

##### **升：
> 打卡，我来迟了

##### **生：
> redis的hash结构应该比string更占用内存空间吧

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 这要看你怎么设计string和hash的key了。实际上，它们占用内存是相差不大的。但hash的好处是你可以根据hashKey查询处单个值，不必像string一样一股脑的查出来，然后在应用端去解析。

